/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.blocks.tiles.TileBuilder;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailability;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcButtonYesNo;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.schematics.ISchematic;
import noppes.npcs.schematics.SchematicWrapper;

public class GuiBlockBuilder
extends GuiNPCInterface
implements IGuiData,
ICustomScrollListener,
IScrollData,
GuiYesNoCallback {
    private GuiCustomScroll scroll;
    private ISchematic selected;
    private final TileBuilder tile;
    private final int x;
    private final int y;
    private final int z;

    public GuiBlockBuilder(int xPos, int yPos, int zPos) {
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 216;
        this.closeOnEsc = true;
        this.selected = null;
        this.x = xPos;
        this.y = yPos;
        this.z = zPos;
        this.tile = (TileBuilder)this.player.field_70170_p.func_175625_s(new BlockPos(this.x, this.y, this.z));
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 3: {
                if (((GuiNpcButtonYesNo)button).getBoolean()) {
                    TileBuilder.SetDrawPos(new BlockPos(this.x, this.y, this.z));
                    this.tile.setDrawSchematic(new SchematicWrapper(this.selected));
                    break;
                }
                TileBuilder.SetDrawPos(null);
                this.tile.setDrawSchematic(null);
                break;
            }
            case 4: {
                this.tile.enabled = ((GuiNpcButtonYesNo)button).getBoolean();
                break;
            }
            case 5: {
                this.tile.rotation = button.getValue();
                break;
            }
            case 6: {
                this.setSubGui(new SubGuiNpcAvailability(this.tile.availability, this));
                break;
            }
            case 7: {
                this.tile.finished = ((GuiNpcButtonYesNo)button).getBoolean();
                Client.sendData(EnumPacketServer.SchematicsSet, this.x, this.y, this.z, this.scroll.getSelected());
                break;
            }
            case 8: {
                this.tile.started = ((GuiNpcButtonYesNo)button).getBoolean();
                break;
            }
            case 10: {
                this.save();
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, "", new TextComponentTranslation("schematic.instantBuildText", new Object[0]).func_150254_d(), 0);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
        }
    }

    public void func_73878_a(boolean flag, int i) {
        if (flag) {
            Client.sendData(EnumPacketServer.SchematicsBuild, this.x, this.y, this.z);
            this.close();
            this.selected = null;
        } else {
            NoppesUtil.openGUI((EntityPlayer)this.player, this);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(125, 208);
        }
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 4;
        this.addScroll(this.scroll);
        if (this.selected != null) {
            int xL = this.guiLeft + 130;
            int xB = this.guiLeft + 200;
            int y = this.guiTop + 4;
            this.addLabel(new GuiNpcLabel(3, "schematic.preview", xL, y + 5));
            this.addButton(new GuiNpcButtonYesNo(3, xB, y, TileBuilder.has(this.tile.func_174877_v())));
            this.addLabel(new GuiNpcLabel(0, new TextComponentTranslation("schematic.width", new Object[0]).func_150254_d() + ": " + this.selected.getWidth(), xL, y += 21));
            this.addLabel(new GuiNpcLabel(1, new TextComponentTranslation("schematic.length", new Object[0]).func_150254_d() + ": " + this.selected.getLength(), xL, y += 11));
            this.addLabel(new GuiNpcLabel(2, new TextComponentTranslation("schematic.height", new Object[0]).func_150254_d() + ": " + this.selected.getHeight(), xL, y += 11));
            this.addButton(new GuiNpcButtonYesNo(4, xB, y += 14, this.tile.enabled));
            this.addLabel(new GuiNpcLabel(4, new TextComponentTranslation("gui.enabled", new Object[0]).func_150254_d(), xL, y + 5));
            this.addButton(new GuiNpcButtonYesNo(7, xB, y += 22, this.tile.finished));
            this.addLabel(new GuiNpcLabel(7, new TextComponentTranslation("gui.finished", new Object[0]).func_150254_d(), xL, y + 5));
            this.addButton(new GuiNpcButtonYesNo(8, xB, y += 22, this.tile.started));
            this.addLabel(new GuiNpcLabel(8, new TextComponentTranslation("gui.started", new Object[0]).func_150254_d(), xL, y + 5));
            this.addLabel(new GuiNpcLabel(9, new TextComponentTranslation("gui.yoffset", new Object[0]).func_150254_d(), xL, (y += 22) + 5));
            GuiNpcTextField textField = new GuiNpcTextField(9, this, xB, y, 50, 20, this.tile.yOffset + "");
            textField.setMinMaxDefault(-10L, 10L, 0L);
            this.addTextField(textField);
            this.addLabel(new GuiNpcLabel(5, new TextComponentTranslation("movement.rotation", new Object[0]).func_150254_d(), xL, (y += 22) + 5));
            this.addButton(new GuiNpcButton(5, xB, y, 50, 20, new String[]{"0", "90", "180", "270"}, this.tile.rotation));
            this.addButton(new GuiNpcButton(6, xL, y += 22, 120, 20, "availability.options"));
            this.addButton(new GuiNpcButton(10, xL, y += 22, 120, 20, "schematic.instantBuild"));
        }
    }

    @Override
    public void initPacket() {
        Client.sendData(EnumPacketServer.SchematicsTile, this.x, this.y, this.z);
    }

    @Override
    public void save() {
        if (this.getTextField(9) != null) {
            this.tile.yOffset = this.getTextField(9).getInteger();
        }
        Client.sendData(EnumPacketServer.SchematicsTileSave, this.x, this.y, this.z, this.tile.writePartNBT(new NBTTagCompound()));
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (!scroll.hasSelected()) {
            return;
        }
        if (this.selected != null) {
            this.getButton(3).setDisplay(0);
        }
        TileBuilder.SetDrawPos(null);
        this.tile.setDrawSchematic(null);
        Client.sendData(EnumPacketServer.SchematicsSet, this.x, this.y, this.z, scroll.getSelected());
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
    }

    @Override
    public void setData(Vector<String> list, HashMap<String, Integer> data) {
        this.scroll.setList(list);
        if (this.selected != null) {
            this.scroll.setSelected(this.selected.getName());
        }
        this.func_73866_w_();
    }

    @Override
    public void setGuiData(final NBTTagCompound compound) {
        if (compound.func_74764_b("Width")) {
            final ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            NBTTagList list = compound.func_150295_c("Data", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                states.add(NBTUtil.func_190008_d((NBTTagCompound)list.func_150305_b(i)));
            }
            this.selected = new ISchematic(){

                @Override
                public IBlockState getBlockState(int i) {
                    return (IBlockState)states.get(i);
                }

                @Override
                public IBlockState getBlockState(int x, int y, int z) {
                    return this.getBlockState((y * this.getLength() + z) * this.getWidth() + x);
                }

                @Override
                public NBTTagList getEntitys() {
                    return new NBTTagList();
                }

                @Override
                public short getHeight() {
                    return compound.func_74765_d("Height");
                }

                @Override
                public short getLength() {
                    return compound.func_74765_d("Length");
                }

                @Override
                public String getName() {
                    return compound.func_74779_i("SchematicName");
                }

                @Override
                public NBTTagCompound getNBT() {
                    return null;
                }

                @Override
                public BlockPos getOffset() {
                    return BlockPos.field_177992_a;
                }

                @Override
                public NBTTagCompound getTileEntity(int i) {
                    return null;
                }

                @Override
                public int getTileEntitySize() {
                    return 0;
                }

                @Override
                public short getWidth() {
                    return compound.func_74765_d("Width");
                }

                @Override
                public boolean hasEntitys() {
                    return false;
                }
            };
            if (TileBuilder.has(this.tile.func_174877_v())) {
                SchematicWrapper wrapper = new SchematicWrapper(this.selected);
                wrapper.rotation = this.tile.rotation;
                this.tile.setDrawSchematic(wrapper);
            }
            this.scroll.setSelected(this.selected.getName());
            this.scroll.scrollTo(this.selected.getName());
        } else {
            this.tile.readPartNBT(compound);
        }
        this.func_73866_w_();
    }

    @Override
    public void setSelected(String selected) {
    }
}

